/*******************************************************************************
  Main Source File

  Company:
    Microchip Technology Inc.

  File Name:
    main.c

  Summary:
    This file contains the "main" function for a project.

  Description:
    This file contains the "main" function for a project.  The
    "main" function calls the "SYS_Initialize" function to initialize the state
    machines of all modules in the system
 *******************************************************************************/

// *****************************************************************************
// *****************************************************************************
// Section: Included Files
// *****************************************************************************
// *****************************************************************************

#include <stddef.h>                     // Defines NULL
#include <stdbool.h>                    // Defines true
#include <stdlib.h>                     // Defines EXIT_FAILURE
#include "definitions.h"                // SYS function prototypes


#include "stdio.h"
#include "1lcd_lib_XC32.h"


bool Timer_Trigger;    //ADϊ^C~OtO
int Count_10msec = 0;       //10mseco߃JE^
int delay_Clock = 200000000;   //200MHz
char Buf[32];
bool LED;

void delay_us(volatile unsigned int usec)        //1secx
{
        volatile  int count;

        count = (int)(delay_Clock/20000000)*usec;


        do      //@at@200MH (Clock=200000000)
        {       //delay_us(1000)F1000.4sec  delay_us(100)F100.6sec  delay_us(10):10.5sec@@delay_us(1)F1.5sec
                asm("NOP"); asm("NOP"); asm("NOP"); asm("NOP"); asm("NOP");asm("NOP");
                asm("NOP"); asm("NOP"); asm("NOP"); asm("NOP"); asm("NOP"); asm("NOP");

                count--;
        }while(count != 0);


}

void delay_ms(volatile unsigned int msec)        //1msecx
{
        volatile unsigned int i;         //Fat200MH (Clock=200000000)//delay_ms(1)F 1.0006msec   delay_ms(100)F100.04msec

        for(i=0; i<msec; i++)
        delay_us(1000);
}



void TMR9_Callback_Fn(uint32_t status, uintptr_t context) //R[obN֐      //1bɌĂяo
{
    Count_10msec++;
    if(Count_10msec >= 25)  //250msec o
    {
        Count_10msec = 0;
        Timer_Trigger = true;
    }

}



void AdcFunc(void)
{
    unsigned short int AdcValue4 = 0;
    unsigned short int AdcValue45 = 0;
    double V_AN4;
    double V_AN45;
    
       //ADϊJn Trigger a conversion 
        //ADCHS_ChannelConversionStart(ADCHS_CH0);//ϊJniO[o\tgEFAGbWgK̏ꍇj
        // ADCHS_ChannelConversionStart();//ϊJniO[o\tgEFAGbWgK̏ꍇj //RpCG[F too few arguments to function 'ADCHS_ChannelConversionStart'  
            ADCCON3bits.GSWTRG = 1; //ϊJniO[o\tgEFAGbWgK̏ꍇj
                    //Trigger conversion for ADC inputs that have selected the GSWTRG bit as the trigger signal, either
                    //through the associated TRGSRC<4:0> bits in the ADCTRGx registers or through the STRGSRC<4:0>
                    //bits in the ADCCON1 register
                    //Class1 ̏ꍇA"ADCCON1bits.STRGSRC = 0;    //XLJngKȂϊIhidefault)ɂ
                    //ϊIAIɃTvOsB

            //ϊ҂ Wait the conversions to complete
            //AN4
//            while(!ADCHS_ChannelResultIsReady(ADCHS_CH4));
            while (ADCDSTAT1bits.ARDY4 == 0);
            //ʂ̎o fetch the result
//            AdcValue4 = ADCHS_ChannelResultGet(ADCHS_CH4);
            AdcValue4 = ADCDATA4;
            
          
            
                 
          //AN45  //AN0
          while(!ADCHS_ChannelResultIsReady(ADCHS_CH0));
//            while (ADCDSTAT1bits.ARDY0 == 0);
            //ʂ̎o fetch the result
            AdcValue45 = ADCHS_ChannelResultGet(ADCHS_CH0) + 0x800;
//            AdcValue45 = ADCDATA0 + 0x800;      // +0x800: ɂ␳  //RpCɃoOH
            //AdcValue45 = ADCDATA0;            //{Ȃ炱̃R[hŐ퓮삷͂B@Harmony v2.04ł͂̃R[hOKłB
    
    lcd_cmd(0x80);          //1ڂ̐擪
    V_AN4 =(double)AdcValue4/4095*3.3;
    sprintf(Buf,"V_AN4=%.2f[V]       ",V_AN4);       //Ƃăobt@[Ɏ[
    lcd_str(Buf);           // JnbZ[W1sڕ\ 
    
    lcd_cmd(0xC0);          //Qsڂ̐擪
     V_AN45 =(double)AdcValue45/4095*3.3;
    sprintf(Buf,"V_AN45=%.2f[V]       ",V_AN45);       //Ƃăobt@[Ɏ[
    lcd_str(Buf);           // JnbZ[W2sڕ\
}







// *****************************************************************************
// *****************************************************************************
// Section: Main Entry Point
// *****************************************************************************
// *****************************************************************************

int main ( void )
{
    /* Initialize all modules */
    SYS_Initialize ( NULL );
    
      
    ADCTRGMODEbits.SH0ALT = 1;  //̓|[gύXF@AN0 --> AN45 
    
     //o̓tH[}bg: unsigned data format
    ADCIMCON1bits.SIGN4 = 0; //o̓tH[}bgF@unsigned short int   //@ unsigned data format
 
    
    lcd_init();				// LCD
    lcd_cmd(0b00001100);    // J[\:OFF  uݸ:OFF

    lcd_cmd(0x80);          //1ڂ̐擪
    sprintf(Buf,"From Now       ");//
    lcd_str(Buf);                   //t\

    lcd_cmd(0xC0);          //Qsڂ̐擪
    sprintf(Buf,"  AD Start !!       ");	//
    lcd_str(Buf);           // JnbZ[W1sڕ\
    
    delay_ms(2000);
    
    TMR9_PeriodSet(3907);  //50 nsec x2  x 3907 x 256 = 1000192sec = 10.00192msec  
                            //NbNF100MHz
    TMR9_Start();   //^C}1@X^[g
    //T1CONbits.ON = 1;     //WX^ڐ
    TMR9_CallbackRegister(TMR9_Callback_Fn, NULL);  //R[obN֐ݒ 
                                                    //void TMR1_CallbackRegister(TMR_CALLBACK callback_fn, uintptr_t context);  

    while ( true )
    {
        /* Maintain state machines of all polled MPLAB Harmony modules. */
        SYS_Tasks ( );
        
        
        delay_us(10);    //K{
        
        
        if(Timer_Trigger == true)     //ADϊA\̃^C~O
        {  
            AdcFunc();      //ADϊA\
            
            Timer_Trigger = 0;  
                
            if(LED == 0)
            {
                LED = 1;
                LATGbits.LATG15 = 1;    //LED ON
            }
            else
            {
                LED = 0;
                LATGbits.LATG15 = 0;    //LED OFF
            }
                     
        }
    }

    /* Execution should not come here during normal operation */

    return ( EXIT_FAILURE );
}


/*******************************************************************************
 End of File
*/

